#! /bin/tcsh -f
# --------------------------------------------------------------------
# REFER TO KEY BELOW FOR VARIABLE DESCRIPTION
# --------------------------------------------------------------------
# analy - the glm directory - where all files are written to
# grpcnt - the group contrast script that is generated
# fsdf - the freesurfer group descriptor file
# oper - id of the user, for seychelles' emails
# hemi - hemisphere
# sm - level of smoothing
# meas - surface measures to be analyzed
# slp - offse / slope comparisons (doss, dods)
#
# CHANGE/REPLACE GCV AND NAMING CONVENTION
#

# this is just needed for diagnostic purposes
setenv DIAG 0x04048

umask 002
setenv SUBJECTS_DIR $SUBJECTS_DIR
set analy = $SUBJECTS_DIR/stats
mkdir -p $analy
set trgt = average
cd $analy
#DEFINE DESIGN FSGD
set fsdf = $analy/gender_age.txt

set Skeleton = ~/.skeleton/glm
if (-f $Skeleton) mv $Skeleton ${Skeleton}.bak
set process_num = 1

#RUN MRIS_GLM FOR EACH HEMI AND EACH SMOOTHING
foreach hemi (lh rh)
	foreach sm (100)  #DEFINE SMOOTHING LEVELS
		foreach meas (thickness)  #DEFINE MEASURED SURFACES
			foreach slp (doss dods)

##################### ESTIMATION
set sufx = _$slp-$meas-$sm$hemi
set est_cmd = (mris_glm --surfmeas $meas \
                --hemi $hemi --trgsubj $trgt --fsgd $fsdf $slp \
                --beta ./beta${sufx}.mgz \
                --var ./var${sufx}.mgz \
                --y ./y${sufx}_000.mgz \
                --nsmooth $sm)

if (`hostname` == seychelles) then
   set est_pn = $process_num
   @ process_num++;
   echo "${est_pn}:: $est_cmd" >> $Skeleton
else $est_cmd
endif


#CLASS Cont
#CLASS Dysl
##################### CONTRAST
if ($slp == doss) then
   ##DOSS
   set c_vctr = ("1 -1 0" \
                 "0 0 1" )  
   set c_name = (  M-F   \
                  Age )
else
   ##DODS
   set c_vctr = ("0 0 1 0" \
                 "0 0 0 1" \
                 "0 0 1 -1")
   set c_name = (  ageM \
                   ageF \
                   age_M-F )
endif

set i=1
while ($i <= $#c_vctr)
      set cntrst_cmd = (mris_glm --hemi $hemi --trgsubj $trgt \
                        --fsgd $fsdf $slp \
                        --beta_in ./beta${sufx}.mgz \
                        --var_in ./var${sufx}.mgz \
                        --gcv $c_vctr[$i] \
                        --ces ./ces_$c_name[$i]${sufx}.mgz \
                        --t ./t_$c_name[$i]${sufx}.mgz \
                        --sigt ./sigt_$c_name[$i]${sufx}.mgz)
      if (`hostname` == seychelles) then
         set cntrst_pn = $process_num
         @ process_num++;
         echo "${cntrst_pn}:${est_pn}: $cntrst_cmd" >> $Skeleton
         else $cntrst_cmd
      endif
      @ i++;
end

end
end
end
end

if (`hostname` == seychelles) launch glm
