/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.soap;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import javax.xml.soap.SOAPException;

class FactoryFinder {
    FactoryFinder() {
    }

    private static Object newInstance(String factoryClassName, ClassLoader classloader) throws SOAPException {
        try {
            Class<?> factory = classloader == null ? Class.forName(factoryClassName) : classloader.loadClass(factoryClassName);
            return factory.newInstance();
        }
        catch (ClassNotFoundException classnotfoundexception) {
            throw new SOAPException("Provider " + factoryClassName + " not found", classnotfoundexception);
        }
        catch (Exception exception) {
            throw new SOAPException("Provider " + factoryClassName + " could not be instantiated: " + exception, exception);
        }
    }

    static Object find(String factoryPropertyName, String defaultFactoryClassName) throws SOAPException {
        ClassLoader classloader;
        try {
            classloader = Thread.currentThread().getContextClassLoader();
        }
        catch (Exception exception) {
            throw new SOAPException(exception.toString(), exception);
        }
        try {
            String factoryClassName = System.getProperty(factoryPropertyName);
            if (factoryClassName != null) {
                return FactoryFinder.newInstance(factoryClassName, classloader);
            }
        }
        catch (SecurityException securityexception) {
            // empty catch block
        }
        try {
            String propertiesFileName = System.getProperty("java.home") + File.separator + "lib" + File.separator + "jaxm.properties";
            File file = new File(propertiesFileName);
            if (file.exists()) {
                FileInputStream fileInput = new FileInputStream(file);
                Properties properties = new Properties();
                properties.load(fileInput);
                fileInput.close();
                String factoryClassName = properties.getProperty(factoryPropertyName);
                return FactoryFinder.newInstance(factoryClassName, classloader);
            }
        }
        catch (Exception exception1) {
            // empty catch block
        }
        String factoryResource = "META-INF/services/" + factoryPropertyName;
        try {
            InputStream inputstream = null;
            inputstream = classloader == null ? ClassLoader.getSystemResourceAsStream(factoryResource) : classloader.getResourceAsStream(factoryResource);
            if (inputstream != null) {
                BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(inputstream, "UTF-8"));
                String factoryClassName = bufferedreader.readLine();
                bufferedreader.close();
                if (factoryClassName != null && !"".equals(factoryClassName)) {
                    return FactoryFinder.newInstance(factoryClassName, classloader);
                }
            }
        }
        catch (Exception exception2) {
            // empty catch block
        }
        if (defaultFactoryClassName == null) {
            throw new SOAPException("Provider for " + factoryPropertyName + " cannot be found", null);
        }
        return FactoryFinder.newInstance(defaultFactoryClassName, classloader);
    }
}

