#!/bin/tcsh -ef

setenv SUBJECTS_DIR ~fischl/local_subjects
set s=bert0
set hemi=$1

limit coredumpsize unlimited
set mdir = $SUBJECTS_DIR/$s/mri
set sdir = $SUBJECTS_DIR/$s/surf
set GCS=$FREESURFER_HOME/average/${hemi}-new2_CURVATURE_40.gcs
set ATLAS=$FREESURFER_HOME/average/${hemi}.average.CURVATURE.tif

set echo=1
cd $mdir

if 0 then
set tpbin = /space/lyon/1/fsdev/work/fsegonne/trunk/dev/mris_fix_topology/mris_fix_topology
set tpbin = ~fischl/cvs/mris_fix_topology/mris_fix_topology	
mris_sphere -inflate -w 0  -q -tol 5e-1 ../surf/${hemi}.inflated ../surf/${hemi}.qsphere
$tpbin -ga $s $hemi
mris_smooth ../surf/${hemi}.orig ../surf/${hemi}.smoothwm
mris_inflate ../surf/${hemi}.smoothwm ../surf/${hemi}.inflated
mris_make_surfaces -mgz $s $hemi
cd $mdir/../surf
mris_sphere -w 0 ./${hemi}.inflated ./${hemi}.sphere

# new killiany/desikan/buckner atlas
set ATLAS=$FREESURFER_HOME/average/${hemi}.average.CURVATURE.tif
set GCS=$FREESURFER_HOME/average/${hemi}-new2_CURVATURE_40.gcs
mris_register -curv $sdir/${hemi}.sphere $ATLAS $sdir/${hemi}.sphere_ad.reg
~fischl/cvs/mris_ca_label/mris_ca_label $s $hemi sphere_ad.reg  $GCS ${hemi}.ad_aparc
endif

#Christophe atlas
set ATLAS=$FREESURFER_HOME/average/${hemi}.average.tif
set GCS=$FREESURFER_HOME/average/${hemi}.atlas2002_simple.gcs
mris_register -curv $sdir/${hemi}.sphere $ATLAS $sdir/${hemi}.sphere.reg
~fischl/cvs/mris_ca_label/mris_ca_label $s $hemi sphere.reg  $GCS ${hemi}.aparc

