#!/bin/tcsh -ef

set s=bert0

setenv SUBJECTS_DIR ~/local_subjects
limit coredumpsize unlimited
set mdir = $SUBJECTS_DIR/$s/mri

set echo=1
cd $mdir
if (-e aseg.mgz) then
		set ASEG=aseg.mgz
else
		set ASEG=aseg
endif

if (-e wm-init == 0) then
		set WMINIT=wm
else
		set WMINIT=wm-init
endif

mri_normalize norm.mgz brain.mgz
mri_segment brain.mgz wm-init.mgz
~fischl/cvs/mri_edit_wm_with_aseg/mri_edit_wm_with_aseg -fillven 1 wm-init.mgz $ASEG wm.mgz
~fischl/cvs/mri_fill/mri_fill -xform $mdir/transforms/talairach.lta -segmentation $ASEG wm.mgz filled.mgz
mri_tessellate filled.mgz 255 ../surf/lh.orig
mri_tessellate filled.mgz 127 ../surf/rh.orig

foreach hemi (lh rh)
		mris_smooth ../surf/${hemi}.orig ../surf/${hemi}.smoothwm
		mris_inflate ../surf/${hemi}.smoothwm ../surf/${hemi}.inflated
end

